/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.items.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.items.ImpactorItemStack;
import net.impactdev.impactor.api.items.builders.provided.BasicItemStackBuilder;
import net.impactdev.impactor.api.items.properties.enchantments.Enchantment;
import net.impactdev.impactor.api.items.types.ItemType;
import net.impactdev.impactor.minecraft.api.items.AdventureTranslator;
import net.impactdev.impactor.minecraft.api.items.ItemStackTranslator;
import net.impactdev.impactor.minecraft.api.items.ServerProvider;
import net.impactdev.impactor.minecraft.items.ImpactorItemType;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4614;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9300;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class ImpactorItemStackTranslator
implements ItemStackTranslator {
    @Override
    public String name() {
        return "ItemStack Translator";
    }

    @Override
    public class_1799 translate(ImpactorItemStack stack) {
        AdventureTranslator translator = AdventureTranslator.get();
        AdventureTranslator.Server serverTranslator = AdventureTranslator.Server.get(ServerProvider.server());
        class_1935 like = ((ImpactorItemType)stack.type()).minecraft().orElse(null);
        class_1799 result = new class_1799(like);
        result.method_7939(stack.quantity());
        if (stack.title() != null) {
            result.method_57379(class_9334.field_49631, (Object)serverTranslator.asNative(stack.title()));
        }
        if (!stack.lore().isEmpty()) {
            ArrayList lore = new ArrayList();
            for (Component line : stack.lore()) {
                lore.add(serverTranslator.asNative(line));
            }
            result.method_57379(class_9334.field_49632, (Object)new class_9290(new ArrayList(), (List)lore));
        }
        for (Enchantment enchantment : stack.enchantments()) {
            class_2960 key = translator.asNative(enchantment.type());
            MinecraftServer server = ServerProvider.server();
            server.method_46221().method_45926().method_33310(class_7924.field_41265).ifPresent(registry -> result.method_7978((class_6880)registry.method_55841(key).orElseThrow(), enchantment.level()));
        }
        if (stack.unbreakable()) {
            result.method_57379(class_9334.field_49630, (Object)new class_9300(true));
        }
        if (stack.nbt() != null) {
            class_2487 nbt = new class_2487();
            this.translateNBT(nbt, stack.nbt());
            result.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        }
        return result;
    }

    @Override
    public ImpactorItemStack from(class_1799 stack) {
        class_9290 lore;
        AdventureTranslator translator = AdventureTranslator.get();
        AdventureTranslator.Server server = AdventureTranslator.Server.get(ServerProvider.server());
        Key key = translator.asAdventure(class_7923.field_41178.method_10221((Object)stack.method_7909()));
        ItemType type = ItemType.from(key);
        BasicItemStackBuilder builder = (BasicItemStackBuilder)((BasicItemStackBuilder)ImpactorItemStack.basic().type(type).title(server.asAdventure(stack.method_7964()))).quantity(stack.method_7947());
        class_9279 custom = (class_9279)stack.method_57824(class_9334.field_49628);
        if (custom != null) {
            builder.nbt(this.translateNativeNBT(custom.method_57461()));
        }
        if ((lore = (class_9290)stack.method_57824(class_9334.field_49632)) != null) {
            builder.lore(lore.comp_2401().stream().map(server::asAdventure).collect(Collectors.toList()));
        }
        builder.unbreakable(stack.method_57826(class_9334.field_49630));
        class_9304 enchantments = (class_9304)stack.method_57824(class_9334.field_49633);
        if (enchantments != null) {
            enchantments.method_57539().forEach(entry -> {
                class_6880 enchantment = (class_6880)entry.getKey();
                int level = entry.getIntValue();
                Key target = translator.asAdventure(((class_5321)enchantment.method_40230().orElseThrow()).method_29177());
                builder.enchantment(Enchantment.create(target, level));
            });
        }
        return (ImpactorItemStack)builder.build();
    }

    private void translateNBT(class_2487 minecraft, CompoundBinaryTag impactor) {
        this.translateCompound(minecraft, impactor);
    }

    private CompoundBinaryTag translateNativeNBT(class_2487 minecraft) {
        AtomicReference<CompoundBinaryTag> result = new AtomicReference<CompoundBinaryTag>(CompoundBinaryTag.empty());
        minecraft.method_10541().forEach(key -> {
            @NotNull class_2520 tag = Objects.requireNonNull(minecraft.method_10580(key));
            byte type = tag.method_10711();
            switch (type) {
                case 1: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putByte(key, ((class_2481)this.from(class_2481.field_21025, tag)).method_10698()));
                    break;
                }
                case 2: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putShort(key, ((class_2516)this.from(class_2516.field_21043, tag)).method_10696()));
                    break;
                }
                case 3: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putInt(key, ((class_2497)this.from(class_2497.field_21037, tag)).method_10701()));
                    break;
                }
                case 4: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putLong(key, ((class_2503)this.from(class_2503.field_21041, tag)).method_10699()));
                    break;
                }
                case 5: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putFloat(key, ((class_2494)this.from(class_2494.field_21035, tag)).method_10700()));
                    break;
                }
                case 6: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putDouble(key, ((class_2489)this.from(class_2489.field_21031, tag)).method_10697()));
                    break;
                }
                case 7: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putByteArray(key, ((class_2479)this.from(class_2479.field_21024, tag)).method_10521()));
                    break;
                }
                case 8: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putString(key, ((class_2519)this.from(class_2519.field_21045, tag)).method_10714()));
                    break;
                }
                case 9: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).put(key, (BinaryTag)this.translateNativeListNBT((class_2499)this.from(class_2499.field_21039, tag))));
                    break;
                }
                case 10: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).put(key, (BinaryTag)this.translateNativeNBT((class_2487)this.from(class_2487.field_21029, tag))));
                    break;
                }
                case 11: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putIntArray(key, ((class_2495)this.from(class_2495.field_21036, tag)).method_10588()));
                    break;
                }
                case 12: {
                    result.set((CompoundBinaryTag)((CompoundBinaryTag)result.get()).putLongArray(key, ((class_2501)this.from(class_2501.field_21040, tag)).method_10615()));
                    break;
                }
                default: {
                    throw new IllegalStateException("End tag encountered");
                }
            }
        });
        return result.get();
    }

    private ListBinaryTag translateNativeListNBT(class_2499 minecraft) {
        AtomicReference<ListBinaryTag> result = new AtomicReference<ListBinaryTag>(ListBinaryTag.empty());
        minecraft.forEach(tag -> {
            byte type = tag.method_10711();
            switch (type) {
                case 1: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2481)this.from((class_4614)class_2481.field_21025, (class_2520)tag)).method_10698(), ByteBinaryTag::byteBinaryTag)));
                    break;
                }
                case 2: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2516)this.from((class_4614)class_2516.field_21043, (class_2520)tag)).method_10696(), ShortBinaryTag::shortBinaryTag)));
                    break;
                }
                case 3: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2497)this.from((class_4614)class_2497.field_21037, (class_2520)tag)).method_10701(), IntBinaryTag::intBinaryTag)));
                    break;
                }
                case 4: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2503)this.from((class_4614)class_2503.field_21041, (class_2520)tag)).method_10699(), LongBinaryTag::longBinaryTag)));
                    break;
                }
                case 5: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(Float.valueOf(((class_2494)this.from((class_4614)class_2494.field_21035, (class_2520)tag)).method_10700()), FloatBinaryTag::floatBinaryTag)));
                    break;
                }
                case 6: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2489)this.from((class_4614)class_2489.field_21031, (class_2520)tag)).method_10697(), DoubleBinaryTag::doubleBinaryTag)));
                    break;
                }
                case 7: {
                    ByteArrayBinaryTag ba = this.toAdventure(((class_2479)this.from((class_4614)class_2479.field_21024, (class_2520)tag)).method_10521(), ByteArrayBinaryTag::byteArrayBinaryTag);
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)ba));
                    break;
                }
                case 8: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.toAdventure(((class_2519)this.from((class_4614)class_2519.field_21045, (class_2520)tag)).method_10714(), StringBinaryTag::stringBinaryTag)));
                    break;
                }
                case 9: {
                    ListBinaryTag lb = this.translateNativeListNBT((class_2499)this.from((class_4614)class_2499.field_21039, (class_2520)tag));
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)lb));
                    break;
                }
                case 10: {
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)this.translateNativeNBT((class_2487)this.from((class_4614)class_2487.field_21029, (class_2520)tag))));
                    break;
                }
                case 11: {
                    IntArrayBinaryTag ia = this.toAdventure(((class_2495)this.from((class_4614)class_2495.field_21036, (class_2520)tag)).method_10588(), IntArrayBinaryTag::intArrayBinaryTag);
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)ia));
                    break;
                }
                case 12: {
                    LongArrayBinaryTag la = this.toAdventure(((class_2501)this.from((class_4614)class_2501.field_21040, (class_2520)tag)).method_10615(), LongArrayBinaryTag::longArrayBinaryTag);
                    result.set((ListBinaryTag)((ListBinaryTag)result.get()).add((BinaryTag)la));
                    break;
                }
                default: {
                    throw new IllegalStateException("End tag encountered");
                }
            }
        });
        return result.get();
    }

    private class_2487 translateCompound(class_2487 source2, CompoundBinaryTag compound) {
        compound.forEach(entry -> {
            String key = (String)entry.getKey();
            BinaryTag tag = (BinaryTag)entry.getValue();
            if (tag.type().equals(BinaryTagTypes.COMPOUND)) {
                source2.method_10566(key, (class_2520)this.translateCompound(new class_2487(), (CompoundBinaryTag)tag));
            } else if (tag.type().equals(BinaryTagTypes.LIST)) {
                source2.method_10566(key, (class_2520)this.translateList((ListBinaryTag)tag));
            } else if (tag.type().equals(BinaryTagTypes.STRING)) {
                source2.method_10582(key, ((StringBinaryTag)this.as(BinaryTagTypes.STRING, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.BYTE)) {
                source2.method_10567(key, ((ByteBinaryTag)this.as(BinaryTagTypes.BYTE, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.SHORT)) {
                source2.method_10575(key, ((ShortBinaryTag)this.as(BinaryTagTypes.SHORT, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.INT)) {
                source2.method_10569(key, ((IntBinaryTag)this.as(BinaryTagTypes.INT, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.LONG)) {
                source2.method_10544(key, ((LongBinaryTag)this.as(BinaryTagTypes.LONG, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.FLOAT)) {
                source2.method_10548(key, ((FloatBinaryTag)this.as(BinaryTagTypes.FLOAT, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.DOUBLE)) {
                source2.method_10549(key, ((DoubleBinaryTag)this.as(BinaryTagTypes.DOUBLE, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.BYTE_ARRAY)) {
                source2.method_10570(key, ((ByteArrayBinaryTag)this.as(BinaryTagTypes.BYTE_ARRAY, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.INT_ARRAY)) {
                source2.method_10539(key, ((IntArrayBinaryTag)this.as(BinaryTagTypes.INT_ARRAY, tag)).value());
            } else if (tag.type().equals(BinaryTagTypes.LONG_ARRAY)) {
                source2.method_10564(key, ((LongArrayBinaryTag)this.as(BinaryTagTypes.LONG_ARRAY, tag)).value());
            }
        });
        return source2;
    }

    private class_2499 translateList(ListBinaryTag list) {
        class_2499 minecraft = new class_2499();
        list.forEach(tag -> {
            if (tag.type().equals(BinaryTagTypes.COMPOUND)) {
                minecraft.add((Object)this.translateCompound(new class_2487(), (CompoundBinaryTag)tag));
            } else if (tag.type().equals(BinaryTagTypes.LIST)) {
                minecraft.add((Object)this.translateList((ListBinaryTag)tag));
            } else if (tag.type().equals(BinaryTagTypes.STRING)) {
                minecraft.add((Object)this.asMinecraft(((StringBinaryTag)this.as((BinaryTagType)BinaryTagTypes.STRING, (BinaryTag)tag)).value(), class_2519::method_23256));
            } else if (tag.type().equals(BinaryTagTypes.BYTE)) {
                minecraft.add((Object)this.asMinecraft(((ByteBinaryTag)this.as((BinaryTagType)BinaryTagTypes.BYTE, (BinaryTag)tag)).value(), class_2481::method_23233));
            } else if (tag.type().equals(BinaryTagTypes.SHORT)) {
                minecraft.add((Object)this.asMinecraft(((ShortBinaryTag)this.as((BinaryTagType)BinaryTagTypes.SHORT, (BinaryTag)tag)).value(), class_2516::method_23254));
            } else if (tag.type().equals(BinaryTagTypes.INT)) {
                minecraft.add((Object)this.asMinecraft(((IntBinaryTag)this.as((BinaryTagType)BinaryTagTypes.INT, (BinaryTag)tag)).value(), class_2497::method_23247));
            } else if (tag.type().equals(BinaryTagTypes.LONG)) {
                minecraft.add((Object)this.asMinecraft(((LongBinaryTag)this.as((BinaryTagType)BinaryTagTypes.LONG, (BinaryTag)tag)).value(), class_2503::method_23251));
            } else if (tag.type().equals(BinaryTagTypes.FLOAT)) {
                minecraft.add((Object)this.asMinecraft(Float.valueOf(((FloatBinaryTag)this.as((BinaryTagType)BinaryTagTypes.FLOAT, (BinaryTag)tag)).value()), class_2494::method_23244));
            } else if (tag.type().equals(BinaryTagTypes.DOUBLE)) {
                minecraft.add((Object)this.asMinecraft(((DoubleBinaryTag)this.as((BinaryTagType)BinaryTagTypes.DOUBLE, (BinaryTag)tag)).value(), class_2489::method_23241));
            } else if (tag.type().equals(BinaryTagTypes.BYTE_ARRAY)) {
                minecraft.add((Object)this.asMinecraft(((ByteArrayBinaryTag)this.as((BinaryTagType)BinaryTagTypes.BYTE_ARRAY, (BinaryTag)tag)).value(), class_2479::new));
            } else if (tag.type().equals(BinaryTagTypes.INT_ARRAY)) {
                minecraft.add((Object)this.asMinecraft(((IntArrayBinaryTag)this.as((BinaryTagType)BinaryTagTypes.INT_ARRAY, (BinaryTag)tag)).value(), class_2495::new));
            } else if (tag.type().equals(BinaryTagTypes.LONG_ARRAY)) {
                minecraft.add((Object)this.asMinecraft(((LongArrayBinaryTag)this.as((BinaryTagType)BinaryTagTypes.LONG_ARRAY, (BinaryTag)tag)).value(), class_2501::new));
            }
        });
        return minecraft;
    }

    private <T extends BinaryTag> T as(BinaryTagType<T> type, BinaryTag tag) {
        return (T)tag;
    }

    private <M extends class_2520, T> M asMinecraft(T value, Function<T, M> translator) {
        return (M)((class_2520)translator.apply(value));
    }

    private <T extends class_2520> T from(class_4614<T> type, class_2520 tag) {
        return (T)tag;
    }

    private <M extends BinaryTag, T> M toAdventure(T value, Function<T, M> translator) {
        return (M)((BinaryTag)translator.apply(value));
    }
}

